/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.config;

import com.teamresourceful.resourcefulconfig.common.annotations.Category;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.trading.Merchant;

@Category(id="revive", translation="text.respawnobelisks.config.revive_config")
public final class ReviveConfig {
    private static List<EntityType<?>> listedEntities = new ArrayList();
    @ConfigEntry(id="enableRevival", type=EntryType.BOOLEAN, translation="text.respawnobelisks.config.enable_revival")
    @Comment(value="Whether entity revival via respawn obelisk should be enabled.")
    public static boolean enableRevival = true;
    @ConfigEntry(id="revivalItem", type=EntryType.STRING, translation="text.respawnobelisks.config.revival_item")
    @Comment(value="Item used to revive an obelisk's saved entities.")
    public static String revivalItem = "minecraft:totem_of_undying";
    @ConfigEntry(id="maxRevivalEntities", type=EntryType.INTEGER, translation="text.respawnobelisks.config.max_revive_entities")
    @Comment(value="Max number of entities that can be revived at once.")
    public static int maxEntities = 3;
    @ConfigEntry(id="revivableEntities", type=EntryType.STRING, translation="text.respawnobelisks.config.revivable_entities")
    @Comment(value="Whitelist for all entities that can be revived. (Tags are supported)\nAny entry beginning with '$' is a hardcoded option that allows for the respective type to pass through.\nAvailable '$'s:\n'$tamables' (any tamable entity),\n'$animals' (pigs, cows, sheep, etc.),\n'$merchants' (villagers)")
    public static String[] revivableEntities = new String[]{"$tamables", "$animals", "$merchants"};
    @ConfigEntry(id="revivableEntitiesBlacklist", type=EntryType.BOOLEAN, translation="text.respawnobelisks.config.revivable_entities_blacklist")
    @Comment(value="Whether the revivable entities list should act as a blacklist.")
    public static boolean entitiesIsBlacklist = false;
    @ConfigEntry(id="revivalCost", type=EntryType.DOUBLE, translation="text.respawnobelisks.config.revival_cost")
    @Comment(value="Obelisk depletion amount when reviving entities.")
    public static double revivalCost = 10.0;

    public static boolean isEntityListed(Entity entity) {
        if (listedEntities.isEmpty()) {
            for (String str : revivableEntities) {
                ResourceLocation loc;
                if (str.startsWith("#")) {
                    TagKey tag;
                    loc = ResourceLocation.m_135820_((String)(str = str.substring(1)));
                    if (loc == null || !Registry.f_122826_.m_203431_(tag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)loc)).isPresent()) continue;
                    for (Holder entityTypeHolder : (HolderSet.Named)Registry.f_122826_.m_203431_(tag).get()) {
                        listedEntities.add((EntityType)entityTypeHolder.m_203334_());
                    }
                    continue;
                }
                loc = ResourceLocation.m_135820_((String)str);
                if (loc == null) continue;
                Registry.f_122826_.m_6612_(loc).ifPresent(e -> listedEntities.add((EntityType<?>)e));
            }
        }
        List<String> entities = Arrays.asList(revivableEntities);
        boolean result = listedEntities.contains(entity.m_6095_()) || entities.contains("$tamables") && entity instanceof OwnableEntity || entities.contains("$animals") && entity instanceof Animal || entities.contains("$merchants") && entity instanceof Merchant;
        return entitiesIsBlacklist != result;
    }
}

